﻿// Called by Directory Opus to initialize the script
function OnInit(initData)
{
	initData.name = "CloseDO";
	initData.version = "1.0";
	initData.copyright = "(c) 2025";
	initData.desc = "Ctrl + 关闭窗口时，退出进程";
	initData.default_enable = true;
	initData.min_version = "13.0";
}

// Called when a Lister is closed
function OnCloseLister(closeListerData)
{
	if (!closeListerData.shutdown) {
		var cmd = DOpus.Create.Command;
		if (closeListerData.qualifiers == "ctrl") {
			cmd.RunCommand('Close PROGRAM=confirm')
			return true
		}
	}
}